
library(memisc)


library(mclogit)


load("model-relmemb-relprin-context.RData")


ls()


setCoefTemplate("horizontal.nostar"=t(c(est="($est:#)", se="(($se:#))")))


getCoefTemplate("horizontal.nostar")


m_relprin <- mtable(model_relprin,
                    coef.style="horizontal.nostar",
                    getSummary=getSummary.mmclogit,
                    gs.options=list(
                        rearrange=list(
                            "Religious Principles" = c("Squared" = "religious_principles.sq",                        
                                                "Linear"  = "religious_principles",                           
                                                "$\\times$ non-Christian"  = "religious_principles:relmembNon-Christian",      
                                                "$\\times$ no religion"    = "religious_principles:relmembNo religion",        
                                                "$\\times$ self-employed"  = "religious_principles:oesch8Self-employed",       
                                                "$\\times$ technical"      = "religious_principles:oesch8Technical",           
                                                "$\\times$ management"     = "religious_principles:oesch8Management",          
                                                "$\\times$ clerks"         = "religious_principles:oesch8Clerks",              
                                                "$\\times$ socio-cultural" = "religious_principles:oesch8Socio-cultural",      
                                                "$\\times$ service worker" = "religious_principles:oesch8Service worker",      
                                                "$\\times$ primary sector" = "religious_principles:oesch8Primary sector",      
                                                "$\\times$ secularization" = "religious_principles:Secularization", 
                                                "$\\times$ non-Christian $\\times$ secularization"  = "religious_principles:relmembNon-Christian:Secularization", 
                                                "$\\times$ no religion $\\times$ secularization"    = "religious_principles:relmembNo religion:Secularization",
                                                "$\\times$ time" = "religious_principles:time", 
                                                "$\\times$ non-Christian $\\times$ time"  = "religious_principles:relmembNon-Christian:time", 
                                                "$\\times$ no religion $\\times$ time"    = "religious_principles:relmembNo religion:time",
                                                "$\\times$ self-employed $\\times$ time"  = "religious_principles:oesch8Self-employed:time",  
                                                "$\\times$ technical $\\times$ time"      = "religious_principles:oesch8Technical:time",      
                                                "$\\times$ management $\\times$ time"     = "religious_principles:oesch8Management:time",     
                                                "$\\times$ clerks $\\times$ time"         = "religious_principles:oesch8Clerks:time",         
                                                "$\\times$ socio-cultural $\\times$ time" = "religious_principles:oesch8Socio-cultural:time", 
                                                "$\\times$ service worker $\\times$ time" = "religious_principles:oesch8Service worker:time", 
                                                "$\\times$ primary sector $\\times$ time" = "religious_principles:oesch8Primary sector:time"),                                  
                            "Immigration" = c("Squared" = "immigration.sq",                                 
                                              "Linear"  = "immigration",               
                                              "$\\times$ non-Christian"  = "relmembNon-Christian:immigration",               
                                              "$\\times$ no religion"    = "relmembNo religion:immigration",                                    
                                              "$\\times$ self-employed"  = "oesch8Self-employed:immigration",                
                                              "$\\times$ technical"      = "oesch8Technical:immigration",                    
                                              "$\\times$ management"     = "oesch8Management:immigration",                   
                                              "$\\times$ clerks"         = "oesch8Clerks:immigration",                       
                                              "$\\times$ socio-cultural" = "oesch8Socio-cultural:immigration",               
                                              "$\\times$ service worker" = "oesch8Service worker:immigration",               
                                              "$\\times$ primary sector" = "oesch8Primary sector:immigration",                 
                                              "$\\times$ time" = "time:immigration",          
                                              "$\\times$ non-Christian $\\times$ time"  = "relmembNon-Christian:time:immigration",          
                                              "$\\times$ no religion $\\times$ time"    = "relmembNo religion:time:immigration",                               
                                              "$\\times$ self-employed $\\times$ time"  = "oesch8Self-employed:time:immigration",           
                                              "$\\times$ technical $\\times$ time"      = "oesch8Technical:time:immigration",               
                                              "$\\times$ management $\\times$ time"     = "oesch8Management:time:immigration",              
                                              "$\\times$ clerks $\\times$ time"         = "oesch8Clerks:time:immigration",                  
                                              "$\\times$ socio-cultural $\\times$ time" = "oesch8Socio-cultural:time:immigration",          
                                              "$\\times$ service worker $\\times$ time" = "oesch8Service worker:time:immigration",          
                                              "$\\times$ primary sector $\\times$ time" = "oesch8Primary sector:time:immigration"),   
                            "Economic Left--Right"= c("Squared" = "lrecon.sq",                                 
                                                  "Linear"  = "lrecon",                                         
                                                 "$\\times$ non-Christian"  = "relmembNon-Christian:lrecon",               
                                                 "$\\times$ no religion"    = "relmembNo religion:lrecon",                                    
                                                 "$\\times$ self-employed"  = "oesch8Self-employed:lrecon",                     
                                                 "$\\times$ technical"      = "oesch8Technical:lrecon",                         
                                                 "$\\times$ management"     = "oesch8Management:lrecon",                        
                                                 "$\\times$ clerks"         = "oesch8Clerks:lrecon",                            
                                                 "$\\times$ socio-cultural" = "oesch8Socio-cultural:lrecon",                    
                                                 "$\\times$ service worker" = "oesch8Service worker:lrecon",                    
                                                 "$\\times$ primary sector" = "oesch8Primary sector:lrecon",                    
                                                 "$\\times$ time" = "time:lrecon",          
                                                 "$\\times$ non-Christian $\\times$ time"  = "relmembNon-Christian:time:lrecon",          
                                                 "$\\times$ no religion $\\times$ time"    = "relmembNo religion:time:lrecon",                                    
                                                 "$\\times$ self-employed $\\times$ time"  = "oesch8Self-employed:time:lrecon",                
                                                 "$\\times$ technical $\\times$ time"      = "oesch8Technical:time:lrecon",                    
                                                 "$\\times$ management $\\times$ time"     = "oesch8Management:time:lrecon",                   
                                                 "$\\times$ clerks $\\times$ time"         = "oesch8Clerks:time:lrecon",                       
                                                 "$\\times$ socio-cultural $\\times$ time" = "oesch8Socio-cultural:time:lrecon",               
                                                 "$\\times$ service worker $\\times$ time" = "oesch8Service worker:time:lrecon",               
                                                 "$\\times$ primary sector $\\times$ time" = "oesch8Primary sector:time:lrecon")
                        )))




m_relprin


m_relprin |> 
    relabel("Var(~(Const.)|CHES_id" = "Var(Party",
            "essround" = "ESS round",
            "CHES_id:" = "Party $\\times$ ",
            "Party x" = "Party $\\times$ ",
            "CHES_id" = "Party",
            fixed=TRUE,gsub=TRUE) |>
    toLatex() |> writeLines(con="relmemb-context-relprin/mtable-relmemb-context-relprin.tex")




